<?php include 'db.php'; ?>
<!DOCTYPE html>
<html>
<head>
    <title>Warranty Lookup</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<div class="container">
    <h2>Warranty Lookup</h2>
    <form method="get" action="">
        <input type="text" name="serial" placeholder="Enter Serial Number" required>
        <button type="submit">Search</button>
    </form>

    <?php
    if (isset($_GET['serial'])) {
        $serial = $_GET['serial'];
        $stmt = $conn->prepare("SELECT * FROM repairs WHERE serial_number = ?");
        $stmt->bind_param("s", $serial);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                echo "<div class='result'>";
                echo "<h3>Repair Details for Serial: " . htmlspecialchars($serial) . "</h3>";
                echo "<p><strong>Repair Type:</strong> " . htmlspecialchars($row['repair_type']) . "</p>";
                echo "<p><strong>Date of Repair:</strong> " . htmlspecialchars($row['repair_date']) . "</p>";
                echo "<p><strong>Warranty Ends:</strong> " . htmlspecialchars($row['warranty_end_date']) . "</p>";
                echo "<p><strong>Notes:</strong><br>" . nl2br(htmlspecialchars($row['notes'])) . "</p>";
                echo "</div>";
            }
        } else {
            echo "<p class='error'>No repair found for this serial number.</p>";
        }
        $stmt->close();
    }
    $conn->close();
    ?>
</div>
</body>
</html>
