<?php
session_start();
if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit();
}
include 'db.php';
?>
<!DOCTYPE html>
<html>
<head>
    <title>Admin - Warranty Program</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<div class="container">
    <h2>Admin Panel</h2>
    <form method="post" action="">
        <input type="text" name="serial_number" placeholder="Serial Number" required><br>
        <input type="text" name="repair_type" placeholder="Repair Type"><br>
        <input type="date" name="repair_date"><br>
        <input type="date" name="warranty_end_date"><br>
        <textarea name="notes" placeholder="Notes..." rows="5"></textarea><br>
        <button type="submit" name="submit">Save Repair Info</button>
    </form>
    <form action="logout.php" method="post">
        <button type="submit" class="logout-btn">Logout</button>
    </form>
    <?php
    if (isset($_POST['submit'])) {
        $stmt = $conn->prepare("INSERT INTO repairs (serial_number, repair_type, repair_date, warranty_end_date, notes) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param("sssss", $_POST['serial_number'], $_POST['repair_type'], $_POST['repair_date'], $_POST['warranty_end_date'], $_POST['notes']);
        $stmt->execute();
        echo "<p class='success'>Repair data saved successfully!</p>";
        $stmt->close();
    }
    $conn->close();
    ?>
</div>
</body>
</html>
